/********************************************************************
 * (C) Copyright 1998 by Hewlett-Packard GmbH. All rights reserved. *
 ********************************************************************/

/***********************************************************************
* File name     : masdefs.h
************************************************************************
* Written by    : Christian Zurhorst, BID R&D, 2.2.98
* Last modified : ask clearcase
************************************************************************
* File contents :
*                 own type definitions, taken out of mini_api.h 
************************************************************************
* NOTES :
************************************************************************
*/

#ifndef MASDEFS_H_INCLUDED                               
#define MASDEFS_H_INCLUDED

#ifndef CLI
#define CLI
#endif


/* ---------------------------------------------------------------
 * Type Definitions for Master Functions
 * --------------------------------------------------------------- */

#define B_MBLOCKPROP_SIZE      	13

CLI typedef enum {
  B_BLK_BUSADDR,     /* @bad   */
  B_BLK_BUSCMD,      /* @cmd   */
  B_BLK_BYTEN,       /* @ben   */
  B_BLK_INTADDR,     /* @iad   */
  B_BLK_NOFDWORDS,   /* @nod   */
  B_BLK_ATTRPAGE,    /* @apage */
  B_BLK_COMPFLAG,    /* @cflag */
  B_BLK_COMPOFFS,    /* @coffs */
  B_BLK_BUSDAC,      /* @dac   */
  B_BLK_BUSADDR_HI,  /* @badhi */
  B_BLK_CONTATTR,    /* @contattr */
  B_BLK_CONDSTART,   /* @cstrt */
  B_BLK_BYTEN_VAR    /* @benv  */
} b_blkproptype;


#define B_MATTRPROP_SIZE	25
/* Caution:
   If you add or remove a property here or change its group,
   do not forget to adjust files dynamic.c and prp_matt.c
   (function Prop2Group()) also.
 */ 
CLI typedef enum {
  B_M_DOLOOP,        /* @loop       */ /* Group 1 */
  B_M_WAITS,         /* @w          */ /* Group 6 */
  B_M_LAST,          /* @last       */ /* Group 9 */
  B_M_RELREQ,        /* @rreq       */ /* Group 7 */ /* HW: arelreq (rel_req_a) */
  B_M_DPERR,         /* @dperr      */ /* Group 7 */
  B_M_DSERR,         /* @dserr      */ /* Group 7 */
  B_M_APERR,         /* @aperr      */ /* Group 5 */ /* HW: aserr (mserr_a) */
  B_M_DWRPAR,        /* @dwp        */ /* Group 8 */
  B_M_AWRPAR,        /* @awp        */ /* Group 5 */
  B_M_WAITMODE,      /* @waitmode   */ /* Group 6 */
  B_M_STEPMODE,      /* @stepmode   */ /* Group 2 */
  B_M_LOCK,          /* @lock       */ /* Group 3 */
  B_M_STEPS,         /* @steps      */ /* Group 2 */
  B_M_TRYBACK,       /* @back       */ /* Group 2 */
  B_M_DELAY,         /* @delay      */ /* Group 1 */ /* HW: idles */
  B_M_REQ64,         /* @req64      */ /* Group 3 */
  B_M_AWRPAR64,      /* @awp64      */ /* Group 5 */
  B_M_DACWRPAR,      /* @dacwp      */ /* Group 5 */
  B_M_DACWRPAR64,    /* @dacwp64    */ /* Group 5 */
  B_M_DACPERR,       /* @dacperr    */ /* Group 5 */
  B_M_DWRPAR64,      /* @dwp64      */ /* Group 5 */
  B_M_DRELREQ,       /* @drreq      */ /* Group 7 */
  B_M_MARKER,        /* @mark       */ /* Group 8 */ 
  B_M_RESUMEDELAY,   /* @resdel     */ /* Group 4 */
  B_M_REPEAT         /* @repeat     */ /* Group 9 */
} b_mattrproptype;

/* the property RESUME_DELAY is not yet included (this feature is not 
 * supported in the first cut of the e2920 PCI series software) */


#define B_MATTR_GRP_NUM		   9
   
/* master attribute group structure */

/* group organization
  B_MATTR_GRP_MA0
    ** E2925
       awrpar
       aperr
       relreq
       stepmode
    ** E2926
       delay
  
  B_MATTR_GRP_MA1
    ** E2926 only
       steps
       tryback
  
  B_MATTR_GRP_MA2
    ** E2926 only
       relreq
       req64
       stepmode
  
  B_MATTR_GRP_MA3
    ** E2926 only
       resumedelay
  
  B_MATTR_GRP_MA4
    ** E2926 only
       aperr
       awrpar
       awrpar64
       dacperr
       dacwp
       dacwp64
  
  B_MATTR_GRP_MD0
       waitmode
  
  B_MATTR_GRP_MD1
       dperr
       dserr
    ** E2925
       dwrpar
    ** E2926
       drelreq
  
  B_MATTR_GRP_MD2
    ** E2926 only
       dwrpar
       dwrpar64
       marker
  
  B_MATTR_GRP_ML
       last
       loop
    ** E2926
       repeat
*/

CLI typedef enum {
  B_MATTR_GRP_MA0, /* @magrpa0 */
  B_MATTR_GRP_MA1, /* @magrpa1 */
  B_MATTR_GRP_MA2, /* @magrpa2 */
  B_MATTR_GRP_MA3, /* @magrpa3 */
  B_MATTR_GRP_MA4, /* @magrpa4 */
  B_MATTR_GRP_MD0, /* @magrpd0 */
  B_MATTR_GRP_MD1, /* @magrpd1 */
  B_MATTR_GRP_MD2, /* @magrpd2 */
  B_MATTR_GRP_ML   /* @magrpl */
} b_mattrgrouptype;


#define B_MGENPROP_SIZE		 15

CLI typedef enum {
  B_MGEN_RUNMODE,        /* @runmode       */
  B_MGEN_REPEATMODE,     /* @repmode       */
  B_MGEN_DELAYCTR,       /* @delayctr      */
  B_MGEN_LATMODE,        /* @latmode       */
  B_MGEN_LATCTR,         /* @latctr        */
  B_MGEN_MWIENABLE,      /* @mwien         */
  B_MGEN_MASTERENABLE,   /* @men           */
  B_MGEN_ATTRMODE,       /* @attrmode      */
  B_MGEN_TRYBACKENABLE,  /* @backen        */
  B_MGEN_DISCONRELOAD,   /* @disreload     */
  B_MGEN_RETRYRELOAD,    /* @retreload     */
  B_MGEN_INVDATAENABLE,  /* @invdataen     */
  B_MGEN_CACHELINESIZE,  /* @clinesize     */
  B_MGEN_WARN64BIT,	 /* @warn64	   */
  B_MGEN_64BIT_RESTRICTION_ENABLE /* @restrict64        */
} b_mastergenproptype;

CLI /* DEF_START ~G_MasterCmd */
/* ---------------------------------------------------------------
 * Defines for Master Functions
 * --------------------------------------------------------------- */
#define B_CMD_INT_ACK              0x0    /* @int_ack */
#define B_CMD_SPECIAL              0x1    /* @special */
#define B_CMD_IO_READ              0x2    /* @io_read */
#define B_CMD_IO_WRITE             0x3    /* @io_write */
#define B_CMD_RESERVED_4           0x4    /* @reserved_4 */
#define B_CMD_RESERVED_5           0x5    /* @reserved_5 */
#define B_CMD_MEM_READ             0x6    /* @mem_read @m_read */
#define B_CMD_MEM_WRITE            0x7    /* @mem_write @m_write */
#define B_CMD_RESERVED_8           0x8    /* @reserved_8 */
#define B_CMD_RESERVED_9           0x9    /* @reserved_9 */
#define B_CMD_CONFIG_READ          0xa    /* @config_read */
#define B_CMD_CONFIG_WRITE         0xb    /* @config_write */
#define B_CMD_MEM_READMULTIPLE     0xc    /* @mem_readmultiple @readmultiple */
#define B_CMD_MEM_READLINE         0xe    /* @mem_readline @readline */
#define B_CMD_MEM_WRITEINVALIDATE  0xf    /* @mem_writeinvalidate @writeinvalidate */
CLI /* DEF_END */

CLI /* DEF_START ~G_MasterDRelreq ~~B_M_DRELREQ */
#define B_DRELREQ_ON         0 /* @drreqon */
#define B_DRELREQ_OFF       31 /* @drreqoff */
CLI /* DEF_END */

CLI /* DEF_START ~G_MasterRelreq ~~B_M_RELREQ */
#define B_RELREQ_ON         0 /* @rreqon */
#define B_RELREQ_OFF       15 /* @rreqoff */
CLI /* DEF_END */

CLI /* DEF_START ~G_MasterStepmode ~~B_M_STEPMODE */
#define B_STEPMODE_STABLE   0x0 /* @stable */
#define B_STEPMODE_TOGGLE   0x1 /* @toggle */
CLI /* DEF_END */

CLI /* DEF_START ~G_MasterWaitmode ~~B_M_WAITMODE */
#define B_WAITMODE_STABLE   0x0 /* @stable */
#define B_WAITMODE_TOGGLE   0x1 /* @toggle */
CLI /* DEF_END */

CLI /* DEF_START ~G_MasterLock ~~B_M_LOCK */
#define B_LOCK_UNCHANGE     0x0 /* @unchange */
#define B_LOCK_LOCK         0x1 /* @lock */
#define B_LOCK_HIDELOCK     0x3 /* @hidelock */
#define B_LOCK_UNLOCK       0x2 /* @unlock */
CLI /* DEF_END */

CLI /* DEF_START ~G_MasterRunmode */
#define B_RUNMODE_IMMEDIATE    0x0  /* @immediate  */
#define B_RUNMODE_WONDELAY     0x1  /* @wondelay   */
#define B_RUNMODE_WONTIMER     0x2  /* @wontimer   */
CLI /* DEF_END */

CLI /* DEF_START ~G_MasterRepeatmode */
#define B_REPEATMODE_SINGLE    0x1  /* @single     */
#define B_REPEATMODE_INFINITE  0x0  /* @infinite   */
CLI /* DEF_END */

CLI /* DEF_START ~G_MasterLatmode */
#define B_LATMODE_OFF          0x0  /* @off */
#define B_LATMODE_ON           0x1  /* @on */
CLI /* DEF_END */

CLI /* DEF_START ~G_G8 */
#define B_CACHESIZE_0          0x0  /* @cache0 */
#define B_CACHESIZE_4          0x4  /* @cache4 */
#define B_CACHESIZE_8          0x8  /* @cache8 */
CLI /* DEF_END */

CLI /* DEF_START ~G_MasterWaits ~~B_M_WAITS */
#define B_M_WAITS_HANG   0xFFFFFFFF /* @whang */
CLI /* DEF_END */

CLI /* DEF_START ~G_MasterAttrmode */
#define B_ATTRMODE_BLOCK       0x0  /* @block */
#define B_ATTRMODE_PAGE        0x2  /* @page */
#define B_ATTRMODE_SEQUENTIAL  0x1  /* @sequential */
CLI /* DEF_END */



#endif


